<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'mautic/mautic';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'aws/aws-crt-php' => 'v1.2.4@eb0c6e4e142224a10b08f49ebf87f32611d162b2',
  'aws/aws-sdk-php' => '3.294.5@2e34d45e970c77775e4c298e08732d64b647c41c',
  'bandwidth-throttle/token-bucket' => '2.0.0@a0c31a4d0fbcf0c1a68c895fc91bf71455bcec08',
  'barryvdh/elfinder-flysystem-driver' => 'v0.4.3@064d5b2c89ca185f3736e7e5c906d76d3632b30c',
  'beberlei/doctrineextensions' => 'v1.3.0@008f162f191584a6c37c03a803f718802ba9dd9a',
  'brick/math' => '0.11.0@0ad82ce168c82ba30d1c01ec86116ab52f589478',
  'composer/ca-bundle' => '1.3.7@76e46335014860eec1aa5a724799a00a2e47cc85',
  'composer/class-map-generator' => '1.1.0@953cc4ea32e0c31f2185549c7d216d7921f03da9',
  'composer/composer' => '2.6.4@d75d17c16a863438027d1d96401cddcd6aa5bb60',
  'composer/installers' => 'v1.12.0@d20a64ed3c94748397ff5973488761b22f6d3f19',
  'composer/metadata-minifier' => '1.0.0@c549d23829536f0d0e984aaabbf02af91f443207',
  'composer/package-versions-deprecated' => '1.11.99.1@7413f0b55a051e89485c5cb9f765fe24bb02a7b6',
  'composer/pcre' => '3.1.0@4bff79ddd77851fe3cdd11616ed3f92841ba5bd2',
  'composer/semver' => '3.4.0@35e8d0af4486141bc745f23a29cc2091eb624a32',
  'composer/spdx-licenses' => '1.5.7@c848241796da2abf65837d51dce1fae55a960149',
  'composer/xdebug-handler' => '3.0.3@ced299686f41dce890debac69273b47ffe98a40c',
  'doctrine/annotations' => '2.0.1@e157ef3f3124bbf6fe7ce0ffd109e8a8ef284e7f',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '1.8.0@2b44dd4cbca8b5744327de78bafef5945c7e7b5e',
  'doctrine/common' => '3.4.3@8b5e5650391f851ed58910b3e3d48a71062eeced',
  'doctrine/data-fixtures' => '1.6.6@4af35dadbfcf4b00abb2a217c4c8c8800cf5fcf4',
  'doctrine/dbal' => '3.6.2@b4bd1cfbd2b916951696d82e57d054394d84864c',
  'doctrine/deprecations' => '1.1.2@4f2d4f2836e7ec4e7a8625e75c6aa916004db931',
  'doctrine/doctrine-bundle' => '2.9.1@7539b3c8bd620f7df6c2c6d510204bd2ce0064e3',
  'doctrine/doctrine-fixtures-bundle' => '3.4.4@9ec3139c52a42e94c9fd1e95f8d2bca94326edfb',
  'doctrine/doctrine-migrations-bundle' => '3.2.2@3393f411ba25ade21969c33f2053220044854d01',
  'doctrine/event-manager' => '1.2.0@95aa4cb529f1e96576f3fda9f5705ada4056a520',
  'doctrine/inflector' => '2.0.6@d9d313a36c872fd6ee06d9a6cbcf713eaa40f024',
  'doctrine/instantiator' => '1.5.0@0a0fa9780f5d4e507415a065172d26a98d02047b',
  'doctrine/lexer' => '2.1.0@39ab8fcf5a51ce4b85ca97c7a7d033eb12831124',
  'doctrine/migrations' => '3.5.5@4b1e2b6ba71d21d0c5be22ed03b6fc954d20b204',
  'doctrine/orm' => '2.15.1@9bc6f5b4ac6f1e7d4248b2efbd01a748782075bc',
  'doctrine/persistence' => '3.2.0@63fee8c33bef740db6730eb2a750cd3da6495603',
  'doctrine/sql-formatter' => '1.1.3@25a06c7bf4c6b8218f47928654252863ffc890a5',
  'egulias/email-validator' => '3.2.5@b531a2311709443320c786feb4519cfaf94af796',
  'exercise/htmlpurifier-bundle' => '4.1.1@153e71b36d90060b5ba52efdec75d6b4bf0fe9bd',
  'ezyang/htmlpurifier' => 'v4.14.0@12ab42bd6e742c70c0a52f7b82477fcd44e64b75',
  'friendsofphp/proxy-manager-lts' => 'v1.0.12@8419f0158715b30d4b99a5bd37c6a39671994ad7',
  'friendsofsymfony/oauth-server-bundle' => 'dev-upgrade-2@dc8ff343363cf794d30eb1a123610d186a43f162',
  'friendsofsymfony/oauth2-php' => '1.3.1@546f869d68fb79b284752e6787263d797165dba4',
  'friendsofsymfony/rest-bundle' => '3.5.0@893f3a01e4d88789abc399c6f1b3cfff79238734',
  'gaufrette/aws-s3-adapter' => 'v0.4.0@a37143f592d5cb0ba124451439af6e6da6784d89',
  'gaufrette/extras' => 'v0.1.0@a2af9a8c53591a4c43a38249e17bcdefdcea8a23',
  'geoip2/geoip2' => 'v2.13.0@6a41d8fbd6b90052bc34dff3b4252d0f88067b23',
  'giggsey/libphonenumber-for-php' => '8.12.56@0f6481df7bee33fe0ed87d2af06770527a2e1c86',
  'giggsey/locale' => '2.2@9c1dca769253f6a3e81f9a5c167f53b6a54ab635',
  'guzzlehttp/guzzle' => '7.8.1@41042bc7ab002487b876a0683fc8dce04ddce104',
  'guzzlehttp/oauth-subscriber' => '0.6.0@8d6cab29f8397e5712d00a383eeead36108a3c1f',
  'guzzlehttp/promises' => '2.0.2@bbff78d96034045e58e13dedd6ad91b5d1253223',
  'guzzlehttp/psr7' => '2.6.2@45b30f99ac27b5ca93cb4831afe16285f57b8221',
  'helios-ag/fm-elfinder-bundle' => '12.3@735b9b0a0f8f1eab47c5001d95e7b16f273e0430',
  'intervention/image' => '2.7.2@04be355f8d6734c826045d02a1079ad658322dad',
  'ip2location/ip2location-php' => '7.2.5@5f637f2e95e51861b9d969aa98f4e5868074f922',
  'jbroadway/urlify' => '1.2.4-stable@d0fafbaa1dc14e8039cdf5c72a932a8d1de1750e',
  'jms/metadata' => '2.6.1@c3a3214354b5a765a19875f7b7c5ebcd94e462e5',
  'jms/serializer' => '3.23.0@ac0b16ee5317d1aacc41deb91c6c325eae97c176',
  'jms/serializer-bundle' => '5.1.0@4b7f6a6cdbbff6000051a2efa29e7566c9a4528e',
  'joomla/filter' => '1.4.4@09733d70db6c6d91e53e0e0d0fcde9b8638175c4',
  'joomla/string' => '2.0.1@bcdb8d45ad3953bf3cfc2b9577288823cab381b9',
  'justinrainbow/json-schema' => 'v5.2.13@fbbe7e5d79f618997bc3332a6f49246036c45793',
  'kamermans/guzzle-oauth2-subscriber' => 'v1.0.12@e1f3a78155fb37410f0103ef57b51fbd4fafd806',
  'knplabs/gaufrette' => 'v0.9.0@786247eba04d4693e88a80ca9fdabb634675dcac',
  'knplabs/knp-menu' => 'v3.3.0@8bd3dc2afa22c65617c563c5e25e62d6e23e98c7',
  'knplabs/knp-menu-bundle' => 'v3.2.0@a0b4224f872d74ae939589eb1ccf0e11291370a9',
  'laminas/laminas-code' => '4.6.0@16ec7577ff315d53ac2e1b1f03a344d8fe680a6e',
  'league/flysystem' => '3.15.1@a141d430414fcb8bf797a18716b09f759a385bed',
  'league/flysystem-local' => '3.15.0@543f64c397fefdf9cfeac443ffb6beff602796b3',
  'league/mime-type-detection' => '1.11.0@ff6248ea87a9f116e78edd6002e39e5128a0d4dd',
  'leezy/pheanstalk-bundle' => 'dev-master@972a5c154e52fd04ec70c13519ddb73dec819700',
  'lightsaml/sp-bundle' => 'dev-symfony5@b73d6b96f651fb2a62ab68cf1ddf76aebf75a6f0',
  'lightsaml/symfony-bridge' => 'dev-symfony5@2d84638b98576b5147febb0def76fdca8edc6447',
  'litesaml/lightsaml' => 'v4.1.4@0cde60745ab89e2fa4934d4659b23b22ea72361a',
  'maennchen/zipstream-php' => '2.2.1@211e9ba1530ea5260b45d90c9ea252f56ec52729',
  'malkusch/lock' => 'v1.4@96cd2d82180fc87bd8ad45aac25486f82d9fbf4b',
  'markbaker/complex' => '3.0.1@ab8bc271e404909db09ff2d5ffa1e538085c0f22',
  'markbaker/matrix' => '3.0.0@c66aefcafb4f6c269510e9ac46b82619a904c576',
  'matomo/device-detector' => '4.3.1@88e5419ee1448ccb9537e287dd09836ff9d2de3b',
  'matthiasmullie/minify' => '1.3.71@ae42a47d7fecc1fbb7277b2f2d84c37a33edc3b1',
  'matthiasmullie/path-converter' => '1.1.3@e7d13b2c7e2f2268e1424aaed02085518afa02d9',
  'mautic/core-lib' => '5.0.0-dev@2e9bf2638929a9ce14cc348cedeabe5799eeff4f',
  'maxmind-db/reader' => 'v1.11.0@b1f3c0699525336d09cc5161a2861268d9f2ae5b',
  'maxmind/web-service-common' => 'v0.9.0@4dc5a3e8df38aea4ca3b1096cee3a038094e9b53',
  'monolog/monolog' => '1.27.1@904713c5929655dc9b97288b69cfeedad610c9a1',
  'mtdowling/jmespath.php' => '2.7.0@bbb69a935c2cbb0c03d7f481a238027430f6440b',
  'mustangostang/spyc' => '0.6.3@4627c838b16550b666d15aeae1e5289dd5b77da0',
  'myclabs/php-enum' => '1.8.4@a867478eae49c9f59ece437ae7f9506bfaa27483',
  'nikic/php-parser' => 'v4.15.1@0ef6c55a3f47f89d7a374e6f835197a0b5fcf900',
  'noxlogic/ratelimit-bundle' => 'v1.19.0@f5fe8e0ae8e1481f16c7c9ad89fae66c89512d37',
  'oneup/uploader-bundle' => '3.2.1@b11ea2060d4d76b7202d24ae170162b70c7a88b6',
  'paragonie/random_compat' => 'v2.0.21@96c132c7f2f7bc3230723b66e89f8f150b29d5ae',
  'pda/pheanstalk' => 'v4.0.4@1a43eb97a53144a2e692bce2ea2be721cc9913a4',
  'php-amqplib/php-amqplib' => 'v2.11.0@9ee212baced63442ca1ab029acde38e1144a00b8',
  'php-amqplib/rabbitmq-bundle' => '2.5.3@c9018526bdc8c35cf01a95975f975a2994015d3f',
  'php-http/guzzle7-adapter' => '1.0.0@fb075a71dbfa4847cf0c2938c4e5a9c478ef8b01',
  'php-http/httplug' => '2.3.0@f640739f80dfa1152533976e3c112477f69274eb',
  'php-http/promise' => '1.1.0@4c4c1f9b7289a2ec57cde7f1e9762a5789506f88',
  'phpoffice/phpspreadsheet' => '1.24.1@69991111e05fca3ff7398e1e7fca9ebed33efec6',
  'phpseclib/phpseclib' => '2.0.38@b03536539f43a4f9aa33c4f0b2f3a1c752088fcd',
  'phpstan/phpdoc-parser' => '1.24.2@bcad8d995980440892759db0c32acae7c8e79442',
  'predis/predis' => 'v1.1.10@a2fb02d738bedadcffdbb07efa3a5e7bd57f8d6e',
  'psr/cache' => '2.0.0@213f9dbc5b9bfbc4f8db86d2838dc968752ce13b',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.0.2@e616d01114759c4c489f93b099585439f795fe35',
  'psr/http-message' => '1.1@cb6ce4845ce34a8ad9e68117c10ee90a29919eba',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'psr/simple-cache' => '2.0.0@8707bf3cea6f710bf6ef05491234e3ab06f6432a',
  'psy/psysh' => 'v0.10.12@a0d9981aa07ecfcbea28e4bfa868031cca121e7d',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'ramsey/collection' => '1.3.0@ad7475d1c9e70b190ecffc58f2d989416af339b4',
  'ramsey/uuid' => '4.7.4@60a4c63ab724854332900504274f6150ff26d286',
  'react/promise' => 'v3.1.0@e563d55d1641de1dea9f5e84f3cccc66d2bfe02c',
  'robrichards/xmlseclibs' => '3.1.1@f8f19e58f26cdb42c54b214ff8a820760292f8df',
  'seld/jsonlint' => '1.10.0@594fd6462aad8ecee0b45ca5045acea4776667f1',
  'seld/phar-utils' => '1.2.1@ea2f4014f163c1be4c601b9b7bd6af81ba8d701c',
  'seld/signal-handler' => '2.0.2@04a6112e883ad76c0ada8e4a9f7520bbfdb6bb98',
  'sensio/framework-extra-bundle' => 'v6.2.10@2f886f4b31f23c76496901acaedfedb6936ba61f',
  'simshaun/recurr' => 'v5.0.1@6887b7bd7075de97c8c69835e0939ff68d23c47e',
  'stack/builder' => 'v1.0.6@a4faaa6f532c6086bc66c29e1bc6c29593e1ca7c',
  'studio-42/elfinder' => '2.1.62@91133c14a341158beca82aede0b2138236a96bc8',
  'symfony/amqp-messenger' => 'v5.4.22@6343af983ba7460f7ea984aacb95d1ed382f6e40',
  'symfony/asset' => 'v5.4.21@1504b6773c6b90118f9871e90a67833b5d1dca3c',
  'symfony/cache' => 'v5.4.23@983c79ff28612cdfd66d8e44e1a06e5afc87e107',
  'symfony/cache-contracts' => 'v2.5.2@64be4a7acb83b6f2bf6de9a02cee6dad41277ebc',
  'symfony/config' => 'v5.4.21@2a6b1111d038adfa15d52c0871e540f3b352d1e4',
  'symfony/console' => 'v5.4.28@f4f71842f24c2023b91237c72a365306f3c58827',
  'symfony/css-selector' => 'v5.4.21@95f3c7468db1da8cc360b24fa2a26e7cefcb355d',
  'symfony/dependency-injection' => 'v5.4.24@4645e032d0963fb614969398ca28e47605b1a7da',
  'symfony/deprecation-contracts' => 'v2.5.2@e8b495ea28c1d97b5e0c121748d6f9b53d075c66',
  'symfony/doctrine-bridge' => 'v5.4.22@decc4801e2ecc4b72334ef472ed82e4d640492ec',
  'symfony/doctrine-messenger' => 'v5.4.21@29aa49b02542503bbcc978c73625d05a9e4ffe4a',
  'symfony/dotenv' => 'v5.4.22@77b7660bfcb85e8f28287d557d7af0046bcd2ca3',
  'symfony/error-handler' => 'v5.4.29@328c6fcfd2f90b64c16efaf0ea67a311d672f078',
  'symfony/event-dispatcher' => 'v5.4.26@5dcc00e03413f05c1e7900090927bb7247cb0aac',
  'symfony/event-dispatcher-contracts' => 'v3.0.2@7bc61cc2db649b4637d331240c5346dcc7708051',
  'symfony/expression-language' => 'v5.4.21@501589522b844b8eecf012c133f0404f0eef77ac',
  'symfony/filesystem' => 'v5.4.25@0ce3a62c9579a53358d3a7eb6b3dfb79789a6364',
  'symfony/finder' => 'v5.4.27@ff4bce3c33451e7ec778070e45bd23f74214cd5d',
  'symfony/form' => 'v5.4.22@e21648e71c579c9ccf5768e2484f79283c463535',
  'symfony/framework-bundle' => 'v5.4.24@c06a56a47817d29318aaace1c655cbde16c998e8',
  'symfony/http-client' => 'v5.4.22@4cd1b7e7ee846c8b22cb47cbc435344af9b2a8bf',
  'symfony/http-client-contracts' => 'v2.5.2@ba6a9f0e8f3edd190520ee3b9a958596b6ca2e70',
  'symfony/http-foundation' => 'v5.4.31@f84fd4fd8311a541ceb2ae3f257841d002450a90',
  'symfony/http-kernel' => 'v5.4.31@d2fad58d32a7b4864d205a7289602a27ce75018c',
  'symfony/intl' => 'v5.4.22@8afe56b8472888d749ef8955acdc9d38578775d7',
  'symfony/lock' => 'v5.4.22@cc0565235e16ef403097fbd30eba59690bee6b3c',
  'symfony/mailer' => 'v5.4.22@6330cd465dfd8b7a07515757a1c37069075f7b0b',
  'symfony/messenger' => 'v5.4.22@5763e92e94908089654bf19cb339c451bde71692',
  'symfony/mime' => 'v5.4.26@2ea06dfeee20000a319d8407cea1d47533d5a9d2',
  'symfony/monolog-bridge' => 'v5.4.22@34be6f0695e4187dbb832a05905fb4c6581ac39a',
  'symfony/monolog-bundle' => 'v3.5.0@dd80460fcfe1fa2050a7103ad818e9d0686ce6fd',
  'symfony/options-resolver' => 'v5.4.21@4fe5cf6ede71096839f0e4b4444d65dd3a7c1eb9',
  'symfony/password-hasher' => 'v6.0.19@2ae49765c5328307e82c0ee2898a39c071ef5bc8',
  'symfony/polyfill-ctype' => 'v1.28.0@ea208ce43cbb04af6867b4fdddb1bdbf84cc28cb',
  'symfony/polyfill-intl-grapheme' => 'v1.28.0@875e90aeea2777b6f135677f618529449334a612',
  'symfony/polyfill-intl-icu' => 'v1.27.0@a3d9148e2c363588e05abbdd4ee4f971f0a5330c',
  'symfony/polyfill-intl-idn' => 'v1.28.0@ecaafce9f77234a6a449d29e49267ba10499116d',
  'symfony/polyfill-intl-normalizer' => 'v1.28.0@8c4ad05dd0120b6a53c1ca374dca2ad0a1c4ed92',
  'symfony/polyfill-mbstring' => 'v1.28.0@42292d99c55abe617799667f454222c54c60e229',
  'symfony/polyfill-php72' => 'v1.28.0@70f4aebd92afca2f865444d30a4d2151c13c3179',
  'symfony/polyfill-php73' => 'v1.28.0@fe2f306d1d9d346a7fee353d0d5012e401e984b5',
  'symfony/polyfill-php80' => 'v1.28.0@6caa57379c4aec19c0a12a38b59b26487dcfe4b5',
  'symfony/polyfill-php81' => 'v1.28.0@7581cd600fa9fd681b797d00b02f068e2f13263b',
  'symfony/process' => 'v5.4.28@45261e1fccad1b5447a8d7a8e67aa7b4a9798b7b',
  'symfony/property-access' => 'v5.4.26@0249e46f69e92049a488f39fcf531cb42c50caaa',
  'symfony/property-info' => 'v6.0.19@e6dfb2223b21768d3b2ae033a5e1f9d205184d45',
  'symfony/redis-messenger' => 'v5.4.22@b511d76ae72bff8d3a316f632c200368e52bcf61',
  'symfony/routing' => 'v5.4.22@c2ac11eb34947999b7c38fb4c835a57306907e6d',
  'symfony/security-acl' => 'v3.0.4@dc8f10b3bda34e9ddcad49edc7accf61f31fce43',
  'symfony/security-bundle' => 'v5.4.22@36eddff8266126de032ab528417ad13eb43f6cb5',
  'symfony/security-core' => 'v5.4.30@3908c54da30dd68c2fe31915d82a1c81809d1928',
  'symfony/security-csrf' => 'v5.4.21@776a538e5f20fb560a182f790979c71455694203',
  'symfony/security-guard' => 'v5.4.22@62d064b1ee682e4617f4c5ddc0d31f73e1a7ecaa',
  'symfony/security-http' => 'v5.4.31@6d3cd5a4deee9697738db8d24258890ca4140ae9',
  'symfony/service-contracts' => 'v2.5.2@4b426aac47d6427cc1a1d0f7e2ac724627f5966c',
  'symfony/stopwatch' => 'v5.4.21@f83692cd869a6f2391691d40a01e8acb89e76fee',
  'symfony/string' => 'v6.0.19@d9e72497367c23e08bf94176d2be45b00a9d232a',
  'symfony/templating' => 'v5.4.21@a47d5f1c8f7a636d27f8918d9cfd508242714e70',
  'symfony/translation' => 'v5.4.24@de237e59c5833422342be67402d487fbf50334ff',
  'symfony/translation-contracts' => 'v2.5.2@136b19dd05cdf0709db6537d058bcab6dd6e2dbe',
  'symfony/twig-bridge' => 'v5.4.31@fc6ee0a3b672ea12ca1f26592d257bfc7f4ee942',
  'symfony/twig-bundle' => 'v5.4.21@875d0edfc8df7505c1993419882c4071fc28c477',
  'symfony/validator' => 'v5.4.22@7c953a48f436bb180d8f5ae471f2665d7dd245da',
  'symfony/var-dumper' => 'v5.4.29@6172e4ae3534d25ee9e07eb487c20be7760fcc65',
  'symfony/var-exporter' => 'v6.0.19@df56f53818c2d5d9f683f4ad2e365ba73a3b69d2',
  'symfony/yaml' => 'v5.4.21@3713e20d93e46e681e51605d213027e48dab3469',
  'theofidry/psysh-bundle' => '4.4.0@c3d3807420961a0c70db3ff1b2527b7138ccf412',
  'tightenco/collect' => 'v8.83.23@a4423c6ace6b54ba4f86c0ac9de588c57bc94d79',
  'twig/twig' => 'v3.7.1@a0ce373a0ca3bf6c64b9e3e2124aca502ba39554',
  'twilio/sdk' => '5.42.2@0cfcb871b18a9c427dd9e8f0ed7458d43009b48a',
  'voku/portable-ascii' => '2.0.1@b56450eed252f6801410d810c8e1727224ae0743',
  'voku/stop-words' => '2.0.1@8e63c0af20f800b1600783764e0ce19e53969f71',
  'wikimedia/less.php' => 'v4.1.0@80694e356d0ea4237e7643d90e60a772b0fe4214',
  'willdurand/jsonp-callback-validator' => 'v2.0.0@738c36e91d4d7e0ff0cac145f77057e0fb88526e',
  'willdurand/negotiation' => '3.1.0@68e9ea0553ef6e2ee8db5c1d98829f111e623ec2',
  'mautic/grapes-js-builder-bundle' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-clearbit' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-cloudstorage' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-crm' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-emailmarketing' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-focus' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-fullcontact' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-gmail' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-outlook' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-social' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-zapier' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/plugin-tagmanager' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-coffee' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-mauve' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-nature' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-aurora' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-blank' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-brienz' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-cards' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-confirmme' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-fresh-center' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-fresh-fixed' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-fresh-left' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-fresh-wide' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-goldstar' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-neopolitan' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-oxygen' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-paprika' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-skyline' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-sparse' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-sunday' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/theme-vibrant' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
  'mautic/mautic' => '5.0.2@7206e4414194abf8b1cfa48fb671f7e75df31121',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!class_exists(InstalledVersions::class, false) || !InstalledVersions::getRawData()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (class_exists(InstalledVersions::class, false) && InstalledVersions::getRawData()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }
}
